# DayBalancer

**Introduced by:** [[Jessie Upp]] | **Depth:** Deep thread

Jessie's "living system" — not a platform — for cooperative networks. She shared her screen to walk Pete and The Nameless One through it.

## The Conversation

Jessie demoed DayBalancer during the call, showing:

- A virtual commons with tables and breakout rooms
- Personal office spaces where members can signal availability ("meet me in my office" / "meet me in the commons")
- Themed rooms (wellness, etc.) for dedicated activities
- Chat capabilities between members
- Stress level tracking and status sharing within trusted networks

> **Jessie:** "The whole point is to get people offline and into the in-person analog life."

### The Experience

Users enter a virtual space where they can see who's available, sit at tables, and organically form connections:

> **Jessie:** "When you're in the actual app and looking to discover, you can filter available in the Commons, and I'm on right now."

She described features like office door locking (with knock alerts) and filtering for available members.

### Circulation, Not Growth

The metric that matters:

> **Jessie:** "What I have been doing is not measuring through growth, but measuring through circulation."

DayBalancer tracks multiple forms of circulation:
- Gratitude shared
- Jobs placed
- Money exchanged
- Time exchanged

These roll up from individual to project to network to ecosystem level:

> **Jessie:** "It also rolls up to the network that we're in, the subnetwork. And then it rolls up to the ecosystem."

### Networks of Networks

Jessie described how separate trusted networks can be associated and their circulation metrics rolled up:

> **Jessie:** "If this network over here, your trusted network, Pete, is creating circulation, and it's showing, and you are associated to another network, those two can be also rolled up for metrics."

### Connection to Other Projects

[[David Witzel]] from the [[GRC]] requested group-within-group functionality — "permeable membranes" between groups like GRC, [[OGM]], and DayBalancer's own spaces.

> **Jessie:** "I would have groups within groups, and have that permeable membrane so that you can go in and out of these groups, GRC to OGM to the campfire."

## Naming and Ownership

Jessie is "helicopter parenting this thing that I'm letting go, and having it name its own self." She plans to rename it — "we're going to change the name DayBalancer, to try to make this really work for all, so it doesn't have a connected name to it."

Links shared in the chat:
- https://app.daybalancer.com/dl/network
- https://www.daybalancer.com/coop-networks
- https://www.daybalancer.com/blog/circular-network

## Related

- [[Jessie Upp]] — the creator
- [[Circulation as a Metric]] — the philosophy behind the metrics
- [[Circles and Emergent Organization]] — the social pattern DayBalancer supports
- [[Doug and Joanna]] — advisors
- [[David Witzel]] — requested group features
- [[GRC]] — one of the networks DayBalancer could connect
- [[OGM]] — another network in the ecosystem
