# IETF

The Internet Engineering Task Force — the standards body that built the internet's protocols.

## In This Conversation

[[Pete Kaminski]] walked [[Jessie Upp]] and [[The Nameless One]] through the IETF's approach to standards as the inspiration for [[Interface Protocol (IFP)]]:

> **Pete:** "They had a natural selection process of writing draft standards and then testing them in the real world. And if people adopted the standard and had independent implementations of the protocols in the standard, then it was used. So there wasn't ever standards that were approved or disapproved. They were all draft."

Pete used RFC 822 (email) and RFC 1036 (multimedia email) as examples of standards that became de facto through adoption.

> **Pete:** "That's the way the internet got built, right? And it was a really good standard."

**Mentioned by:** [[Pete Kaminski]]  
**Context:** Explaining the lineage of IFP's design philosophy

## In the Inter-Face Manifesto

The [[Inter-Face Manifesto]] names the IETF explicitly in two of its principles:

- **"Rough consensus and running code"** — IFP conventions evolve through a proposal process inspired by the IETF RFC process. Proposals get adopted if people find them useful; different implementations can coexist.
- **Departure from the Robustness Principle** — The manifesto deliberately replaces the IETF's classic "be liberal in what you accept" with "be explicit when you don't understand what you receive," arguing that AI agents can be updated quickly and that silent tolerance of deviations leads to protocol decay.

## Related

- [[Inter-Face Manifesto]] — the full vision document, drawing on IETF philosophy
- [[Interface Protocol (IFP)]] — directly inspired by IETF processes
- [[Nostr]] — another re-implementation of the RFC model
- [[Pete Kaminski]] — internet standards veteran
